﻿using System;
using System.Xml.Serialization;
using System.Runtime.Serialization;
using InfoWorld.HL7.ITS;

namespace BMS.DataContracts
{
    /// <summary>
    /// Contains data about admissions managed by BMS.
    /// </summary>
    [Serializable]
    [XmlType(TypeName = "AdmissionEvent")]
    [DataContract(Name = "AdmissionEvent")]   
    [KnownType(typeof(CD))]    
    [KnownType(typeof(II))]
    [KnownType(typeof(Event))]
    public class AdmissionEvent : Event
    {        
        /// <summary>
        /// Gets or sets the nurse id that attends the admission(EIS person).
        /// </summary>
        /// <value>
        /// The attending nurse id.
        /// </value>
        [XmlElementAttribute("AttendingNurseId", Order = 1)]
        [DataMember(EmitDefaultValue = false, Name = "AttendingNurseId", Order = 1)]
        public II AttendingNurseId { get; set; }                

        /// <summary>
        /// Gets or sets the date of the admission event.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        [XmlElementAttribute("AdmissionDate", Order = 2)]
        [DataMember(EmitDefaultValue = false, Name = "AdmissionDate", Order = 2)]
        public DateTime? AdmissionDate  { get; set; }

        /// <summary>
        /// Gets or sets the person who made the admission.
        /// </summary>
        /// <value>
        /// The entered by id.
        /// </value>
        [XmlElementAttribute("EnteredById", Order = 3)]
        [DataMember(EmitDefaultValue = false, Name = "EnteredById", Order = 3)]
        public II EnteredById { get; set; }

        /// <summary>
        /// Gets or sets the type of the movement(VistA related).
        /// </summary>
        /// <value>
        /// The type of the movement.
        /// </value>
        [XmlElementAttribute("MovementType", Order = 4)]
        [DataMember(EmitDefaultValue = false, Name = "MovementType", Order = 4)]
        public CD MovementType { get; set; }

        /// <summary>
        /// Gets or sets a value indicating whether this instance has discharge.
        /// </summary>
        /// <value>
        /// 	<c>true</c> if this instance has discharge; otherwise, <c>false</c>.
        /// </value>
        [XmlElementAttribute("HasDischarge", Order = 5)]
        [DataMember(EmitDefaultValue = false, Name = "HasDischarge", Order = 5)]
        public bool HasDischarge { get; set; }
    }
}
